//
//  GPGKeySelectionPanel.h
//  GPGAppKit
//
//  Created by Simon Stapleton on Thu Feb 21 2002.
//
//  Copyright (C) 2001-2002 Mac GPG Project.
//
//  This code is free software; you can redistribute it and/or modify it under
//  the terms of the GNU General Public License as published by the Free
//  Software Foundation; either version 2 of the License, or any later version.
//
//  This code is distributed in the hope that it will be useful, but WITHOUT ANY
//  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
//  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
//  details.
//
//  For a copy of the GNU General Public License, visit <http://www.gnu.org/> or
//  write to the Free Software Foundation, Inc., 59 Temple Place--Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  More info at <http://macgpg.sourceforge.net/> or <macgpg@rbisland.cx>
//

#import <AppKit/AppKit.h>
#import <GPGME/GPGME.h>

@interface GPGKeySelectionPanel : NSPanel {
  @private

  BOOL okPressed;
  BOOL listsSecretKeys;
  BOOL listsAllNames;
  GPGValidity minimumKeyValidity;
  NSMutableArray * keys;  
}

- (id) initWithContentRect: (NSRect) aRect
                 styleMask: (unsigned int) mask
                   backing: (NSBackingStoreType) backing
                     defer: (BOOL) defer;

- (BOOL) okPressed;
- (void) setOkPressed: (BOOL) yesNo;
- (BOOL) listsSecretKeys;
- (void) setListsSecretKeys: (BOOL) yesNo;
- (BOOL) listsAllNames;
- (void) setListsAllNames: (BOOL) yesNo;
- (GPGValidity) minimumKeyValidity;
- (void) setMinimumKeyValidity: (GPGValidity) aValidity;

- (void) beginSheetForKeyWildcard: (NSString *) wildcard
                     usingContext: (GPGContext *) context
                   modalForWindow: (NSWindow *) window
                    modalDelegate: (id) delegate
                   didEndSelector: (SEL) endSelector
                      contextInfo: (id) info;
- (BOOL) runModalForKeyWildcard: (NSString *) wildcard
                   usingContext: (GPGContext *) aContext;

- (void) resetKeyListForWildcard: (NSString *) wildcard
                    usingContext: (GPGContext *) context;
- (void) addObjectToSelectorTitled:(NSString *)title;

- (IBAction) cancel: (id) sender;
- (IBAction) ok: (id) sender;

- (NSArray *) keys;

@end
